@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container-fluid">
                <div class="page-title-box">
                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="/tour-adding" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" readonly type="text" value="{{ $data->name }}"
                                                name="name" required>
                                            <input class="form-control" readonly type="hidden" value="{{ $data->id }}"
                                                name="clientid" required>

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="email" value="{{ $data->email }}"
                                                name="email" required>

                                        </div>
                                    </div>
                                    <h4 class="mt-0 header-title"> </h4>
                                    <div class="">
                                        <div class="dynamic-table">
                                            <table class="table table-bordered responsive" id="dynamic-table">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Booking</th>

                                                        <th>Spectial Note</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            Date <input class="form-control " type="Date" required name="date[0]">
                                                            <input type="hidden" name="day[0]" value="1"> <br>
                                                            <input type="text" name="weather[0]" value="1"> 
                                                      

                                                        </td>
                                                        <td> Name<input class="form-control " type="text" required
                                                                name="hotel[0] ">
                                                            <br> Contact <input class="form-control " type="text"
                                                                required name="h_contact[0] "><br> Address <input
                                                                class="form-control " type="text" name="h_address[0] ">
                                                            <br> Price<input class="form-control " type="text" required
                                                                name="h_price[0] "> <br>
                                                            <br> Destination<input class="form-control pac-target-input"
                                                                type="text" required name="h_place[0] "> <br>
                                                        </td>

                                                        <td><input class="form-control " type="text" name="h_note[0]">
                                                        </td>
                                                        <td> <button class="btn-success" id="add-row">Add Row</button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Detail</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="deatil">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Package</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="package">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="price">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 col-form-label">Pre Paid</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="prepaid">
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
            </div>
            <!-- container-fluid -->
        </div>
        <!-- content -->
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize the autocomplete for the input field with class 'pac-target-input'
            var destinationInput = document.querySelector('.pac-target-input');
            var autocomplete = new google.maps.places.Autocomplete(destinationInput, {
                componentRestrictions: {
                    country: 'LK' // 'LK' is the country code for Sri Lanka
                }
            });

            // Function to initialize Autocomplete for a specific row
            function initializeAutocompleteForNewRow(row) {
                var destinationInput = row.find('.pac-target-input')[0];
                var autocomplete = new google.maps.places.Autocomplete(destinationInput, {
                    componentRestrictions: {
                        country: 'LK' // 'LK' is the country code for Sri Lanka
                    }
                });
            }

            var i = 0; // Initialize i to 0
            var d = 1;

            // Add Row button click event
            $('#add-row').click(function() {
                event.preventDefault();
                // Create a new row
                i++;
                d++;
                var newRow = $('<tr>');

                // Add input fields to the row
                newRow.append('<td>Date<input class="form-control" type="date" required name="date[' + i +
                    ']"> <input type="hidden" name="day[' + i + ']" value="' + d + '"></td>');
                newRow.append('<td> Name<input class="form-control" type="text" required name="hotel[' + i +
                    ']"> <br> Contact <input class="form-control" type="text" required name="h_contact[' +
                    i +
                    ']"><br> Address <input class="form-control" type="text" required name="h_address[' +
                    i +
                    ']"><br> Price <input class="form-control" type="text" required name="h_price[' +
                    i +
                    ']"><br> Destination <input class="form-control pac-target-input" type="text" required name="h_place[' +
                    i + ']"> </td>');
                newRow.append('<td><input class="form-control" type="text" name="h_note[' + i + ']"></td>');
                newRow.append('<td><button class="delete-row btn-danger">Delete</button></td>');

                // Append the new row to the table body
                $('#dynamic-table tbody').append(newRow);

                // Initialize Autocomplete for the new row
                initializeAutocompleteForNewRow(newRow);
            });

            // Delete row button click event
            $('#dynamic-table').on('click', '.delete-row', function() {
                event.preventDefault();
                $(this).closest('tr').remove();
            });
        });
    </script>

    {{-- <script>
        $(document).ready(function() {
            var i = 0; // Initialize i to 0
            var d = 1;
            // Add Row button click event
            $('#add-row').click(function() {
                event.preventDefault()
                // Create a new row
                i++;
                d++;
                var newRow = $('<tr>');
                // Add input fields to the row
                newRow.append('<td>Date<input class="form-control" type="date" name="date[' + i +
                    ']"> <input type="hidden" name="day[' + i + ']" value="' + d +
                    '"></td>');
                newRow.append('<td> Name<input class="form-control" type="text" name="hotel[' + i +
                    ']"> <br> Contact <input class="form-control" type="text" name="h_contact[' + i +
                    ']"><br> Address <input class="form-control" type="text" name="h_address[' + i +
                    ']"><br> Price <input class="form-control" type="text" name="h_price[' + i +
                    ']"><br> Destination <input  class="form-control pac-target-input" type="text" name="h_place[' + i +
                    ']"> </td>');

                newRow.append('<td><input class="form-control" type="text" name="h_note[' + i +
                    ']"></td>');
                newRow.append('<td><button class="delete-row btn-danger">Delete</button></td>');
                // Append the new row to the table body
                $('#dynamic-table tbody').append(newRow);
                event.preventDefault()
            });
            // Delete row button click event
            $('#dynamic-table').on('click', '.delete-row', function() {
                event.preventDefault()
                $(this).closest('tr').remove();
            });
        });
    </script> --}}
@endsection
